<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTranscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('transcriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('application_id')->unsigned()->index();
			$table->integer('transcribed_user_id')->unsigned()->index();
			$table->integer('qa_user_id')->unsigned()->index();
			$table->integer('audit_user_id')->unsigned()->index();
			$table->string('external_id', 255)->index();
			$table->boolean('transcribed')->default(0);
			$table->boolean('qad')->default(0);
			$table->boolean('audited')->default(0);
			$table->string('inserted_by', 25)->nullable();
			$table->boolean('locked')->default(0);
			$table->integer('locked_by')->unsigned()->nullable()->index();
			$table->timestamp('locked_until')->nullable();
			$table->boolean('requires_admin')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('transcriptions');
	}
}