<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserHistoryTable extends Migration {

	public function up()
	{
		Schema::create('user_history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->index();
			$table->enum('type', array('Transcription', 'Application', 'Client', 'Field', 'Extract', 'Queue', 'User', 'Role'));
			$table->integer('subject_id')->unsigned();
			$table->string('change_description', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_history');
	}
}