<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationTable extends Migration {

	public function up()
	{
		Schema::create('application', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id')->unsigned()->index();
			$table->tinyInteger('audit_percentage')->nullable()->default('20');
			$table->string('external_id', 255)->index();
			$table->string('external_subaccount_id', 8)->index();
			$table->boolean('encrypted')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('application');
	}
}