<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldTable extends Migration {

	public function up()
	{
		Schema::create('field', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('application_id')->unsigned()->index();
			$table->string('name', 255)->nullable();
			$table->string('field_type', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('field');
	}
}