<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Queue extends Eloquent {

	protected $table = 'queues';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function applications()
	{
		return $this->hasMany('Application');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

}