<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Queue extends Model 
{

    protected $table = 'queues';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function applications()
    {
        return $this->hasMany('Application');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

}