<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Transcription extends Model 
{

    protected $table = 'transcriptions';
    public $timestamps = true;

    public function transcribedBy()
    {
        return $this->hasOne('User', 'transcribed_user_id');
    }

    public function QABy()
    {
        return $this->hasOne('User', 'qa_user_id');
    }

    public function lockedBy()
    {
        return $this->hasOne('User', 'locked_by');
    }

    public function auditedBy()
    {
        return $this->hasOne('User', 'audit_user_id');
    }

}