<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShopOwnersTable extends Migration {

	public function up()
	{
		Schema::create('shop_owners', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('availability_id')->unsigned();
			$table->string('shop_name', 191);
			$table->string('location', 191);
			$table->string('doc1', 191);
			$table->string('doc2', 191);
			$table->enum('availability_type', array('['shop'', ''home']'));
			$table->bigInteger('total_chairs');
			$table->bigInteger('available_chairs');
			$table->enum('status', array('['active'', ''inactive'', ''block']'));
			$table->float('average_rating');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('shop_owners');
	}
}