<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('professionals', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('professionals', function(Blueprint $table) {
			$table->foreign('availability_id')->references('id')->on('availabilities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('shop_owners', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('shop_owners', function(Blueprint $table) {
			$table->foreign('availability_id')->references('id')->on('availabilities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('contract_chairs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('contract_chairs', function(Blueprint $table) {
			$table->foreign('shop_id')->references('id')->on('shop_owners')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('contract_chairs', function(Blueprint $table) {
			$table->foreign('dependent_pro_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('service_books', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('service_books', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id_customer')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('user_id_customer')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('user_id_indep_pro')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('user_id_shop')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('user_id_dep_pro')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('estores', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('estore_id')->references('id')->on('estores')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('estore_id')->references('id')->on('estores')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id_customer')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('professionals', function(Blueprint $table) {
			$table->dropForeign('professionals_user_id_foreign');
		});
		Schema::table('professionals', function(Blueprint $table) {
			$table->dropForeign('professionals_availability_id_foreign');
		});
		Schema::table('shop_owners', function(Blueprint $table) {
			$table->dropForeign('shop_owners_user_id_foreign');
		});
		Schema::table('shop_owners', function(Blueprint $table) {
			$table->dropForeign('shop_owners_availability_id_foreign');
		});
		Schema::table('contract_chairs', function(Blueprint $table) {
			$table->dropForeign('contract_chairs_user_id_foreign');
		});
		Schema::table('contract_chairs', function(Blueprint $table) {
			$table->dropForeign('contract_chairs_shop_id_foreign');
		});
		Schema::table('contract_chairs', function(Blueprint $table) {
			$table->dropForeign('contract_chairs_dependent_pro_id_foreign');
		});
		Schema::table('service_books', function(Blueprint $table) {
			$table->dropForeign('service_books_service_id_foreign');
		});
		Schema::table('service_books', function(Blueprint $table) {
			$table->dropForeign('service_books_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_customer_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_user_id_customer_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_user_id_indep_pro_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_user_id_shop_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_user_id_dep_pro_foreign');
		});
		Schema::table('estores', function(Blueprint $table) {
			$table->dropForeign('estores_user_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_estore_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_estore_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_customer_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_product_id_foreign');
		});
	}
}