<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Availability extends Model 
{

    protected $table = 'availabilities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function independentProAvailabilities()
    {
        return $this->hasMany('IndependentProfessionals', 'availability_id', 'id');
    }

    public function shopOwnerAvailabilities()
    {
        return $this->hasMany('ShopOwner', 'user_id', 'id');
    }

}