<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkillsTable extends Migration {

	public function up()
	{
		Schema::create('skills', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique()->nullable();
			$table->string('slug')->unique();
			$table->bigInteger('icon')->nullable();
			$table->string('color')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('skills');
	}
}