<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFleetParticipantsTable extends Migration {

	public function up()
	{
		Schema::create('fleet_participants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('check_id')->index();
			$table->bigInteger('fleet_id')->index();
			$table->bigInteger('wing_id')->index();
			$table->bigInteger('squad_id')->index();
			$table->string('role', 150)->nullable();
			$table->string('role_name', 150)->nullable();
			$table->bigInteger('character_id')->index();
			$table->bigInteger('ship_type_id')->nullable()->index();
			$table->datetime('join_time')->index();
			$table->boolean('takes_fleet_warp')->index();
			$table->bigInteger('solar_system_id')->nullable()->index();
			$table->bigInteger('station_id')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('fleet_participants');
	}
}