<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComponentsTable extends Migration {

	public function up()
	{
		Schema::create('components', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('component_model_id')->unsigned();
			$table->integer('shelter_id')->unsigned();
			$table->string('component', 255);
			$table->string('name', 255);
			$table->integer('from');
			$table->integer('to');
			$table->string('author', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('components');
	}
}