<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanificationsTable extends Migration {

	public function up()
	{
		Schema::create('planifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('maintenancetype_id')->unsigned();
			$table->date('date');
			$table->string('statut', 254);
			$table->integer('asset_id')->unsigned();
			$table->integer('site_id')->unsigned();
			$table->string('label', 255);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('planifications');
	}
}