<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateZonesTable extends Migration {

	public function up()
	{
		Schema::create('zones', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_id')->unsigned();
			$table->string('label', 255);
			$table->float('surface');
			$table->float('surface_value');
			$table->float('installed_capacity');
			$table->float('installed_capacity_value');
			$table->string('author', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('zones');
	}
}