<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmailsTable extends Migration {

	public function up()
	{
		Schema::create('emails', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 55)->unique();
			$table->enum('action', array('unbox', 'sent'));
			$table->string('subject', 55);
			$table->string('mailBody', 155);
			$table->date('dateAdded');
			$table->enum('type', array('email', 'sms'));
			$table->string('resultCode', 55);
			$table->string('star', 55);
			$table->string('send', 55);
			$table->string('complete', 55);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('emails');
	}
}