<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCodePromosTable extends Migration {

	public function up()
	{
		Schema::create('code_promos', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->nullable()->default('null');
			$table->string('code')->unique();
			$table->float('pourcentage');
			$table->boolean('statut');
			$table->datetimeTz('date_debut');
			$table->datetimeTz('date_expiration');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('code_promos');
	}
}