<?php

namespace App\Models\Client;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function commandes()
	{
		return $this->hasMany('App\Models\Commandes\Commande');
	}

	public function code_promos()
	{
		return $this->hasMany('App\Models\CodePromo\CodePromo');
	}

	public function notation_clients()
	{
		return $this->hasMany('App\Models\NotificationClient\NotificationClient');
	}

}