<?php

namespace App\Models\Modele;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Modele extends Eloquent {

	protected $table = 'modeles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function vehicules()
	{
		return $this->hasMany('App\Models\Vehicule\Vehicule');
	}

	public function marque()
	{
		return $this->belongsTo('App\Models\Marque\Marque');
	}

}