<?php

namespace App\Models\VehiculeOffre;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class VehiculeOffre extends Eloquent {

	protected $table = 'vehicule_offres';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function offre()
	{
		return $this->belongsTo('App\Models\Offre\Offre');
	}

	public function vehicule()
	{
		return $this->belongsTo('App\Models\Vehicule\Vehicule');
	}

}