<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAkdSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('akd_schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('bm_id')->unsigned()->nullable()->index();
			$table->string('name', 191)->index();
			$table->date('schedule_date')->index();
			$table->integer('akd_id')->unsigned()->nullable()->index();
			$table->integer('legend_id')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('akd_schedules');
	}
}