<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvitationsTable extends Migration {

	public function up()
	{
		Schema::create('invitations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('date')->index();
			$table->string('number')->unique();
			$table->string('category', 191)->index()->default('NULL');
			$table->string('supplement', 191)->index()->default('NULL');
			$table->string('topic', 191)->index();
			$table->text('carbon_copy')->nullable();
			$table->string('to', 191)->index();
			$table->integer('bm_id')->unsigned()->nullable()->index();
			$table->string('group', 191)->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('invitations');
	}
}