<?php

namespace UserTrait;

class Investor extends Eloquent {

	protected $table = 'investors';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function investments()
	{
		return $this->hasMany('Investment');
	}

	public function products()
	{
		return $this->belongsToMany('Product', 'investments')->withPivot('bid_price','num_shares');
	}

}