<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConcesionTable extends Migration {

	public function up()
	{
		Schema::create('concesion', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('numerodeconcesion', 45)->unique();
			$table->date('fecharegistro')->nullable();
			$table->date('fechaemision');
			$table->integer('vigencia')->default('10');
			$table->date('fechavencimiento')->nullable();
			$table->date('fechaprorroga')->nullable();
			$table->integer('administrador_id')->nullable();
			$table->integer('representante_id')->nullable();
			$table->string('driveid', 45)->nullable();
			$table->integer('concesion_conagua_id')->nullable();
			$table->string('etiquetas', 255)->nullable();
			$table->integer('user_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('concesion');
	}
}