<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVybesTable extends Migration {

	public function up()
	{
		Schema::create('vybes', function(Blueprint $table) {
			$table->uuid('uid')->primary()->index();
			$table->string('track_title');
			$table->string('track_artist');
			$table->string('track_isrc');
			$table->string('spotify_id');
			$table->string('applemusic_id');
			$table->string('cover');
			$table->text('comment')->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vybes');
	}
}