<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lookup extends Model 
{

    protected $table = 'lookups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('parent_id', 'slug', 'title', 'is_active', 'is_editable');

    public function users()
    {
        return $this->belongsToMany('User');
    }

    public function massages()
    {
        return $this->belongsToMany('Massage');
    }

}