<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Massage extends Model 
{

    protected $table = 'contact_us_massages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'comment', 'branch_id', 'request_type');

    public function branch()
    {
        return $this->belongsTo('Branch');
    }

    public function lookup()
    {
        return $this->belongsTo('Lookup');
    }

}