<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Branch extends Eloquent {

	protected $table = 'branches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'is_active');

	public function contacts()
	{
		return $this->hasMany('Massage');
	}

	public function addresses()
	{
		return $this->morphMany('Address', 'addressable');
	}

	public function details()
	{
		return $this->hasMany('ContactDetails');
	}

	public function services()
	{
		return $this->belongsToMany('Service');
	}

}