<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ContactDetails extends Eloquent {

	protected $table = 'contact-details';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('type', 'value', 'icon', 'title', 'order', 'branch_id');

	public function branch()
	{
		return $this->belongsTo('Branch');
	}

}