<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'subtitle', 'description', 'icon', 'order');

	public function branches()
	{
		return $this->belongsToMany('Branch');
	}

}