<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'first_name', 'last_name', 'email', 'phone', 'password', 'role_id', 'is_susbended');

	public function addresses()
	{
		return $this->morphMany('Address', 'addressable');
	}

	public function lookup()
	{
		return $this->belongsTo('Lookup');
	}

}