<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('comment');
			$table->integer('rating')->nullable();
			$table->text('full_name');
			$table->text('email');
			$table->integer('service_id')->unsigned();
			$table->integer('department_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}