<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('fullname', 'username', 'password', 'type', 'city_id', 'gender', 'address', 'mobile', 'email', 'status', 'mobile_approved', 'vip', 'website_link', 'birthday', 'nationality_id', 'disability_id', 'current_subscription_id');

    public function city()
    {
        return $this->belongsTo('Models\City', 'city_id');
    }

    public function nationality()
    {
        return $this->belongsTo('Models\City', 'nationality_id');
    }

    public function disability()
    {
        return $this->belongsTo('Models\Disability', 'disability_id');
    }

    public function worker_detail()
    {
        return $this->hasOne('Worker', 'user_id');
    }

    public function current_subscription()
    {
        return $this->belongsTo('Subscription', 'current_subscription_id');
    }

    public function company_details()
    {
        return $this->hasOne('Company', 'user_id');
    }

    public function favourite_jobs()
    {
        return $this->belongsToMany('Job', 'favourites', 'user_id', 'job_id');
    }

    public function applied_jobs()
    {
        return $this->belongsToMany('Job', 'applied_jobs', 'user_id', 'job_id');
    }

    public function documents()
    {
        return $this->hasMany('Documents', 'user_id');
    }

    public function sender_room()
    {
        return $this->belongsToMany('User', 'room_id', 'sender_id', 'receiver_id');
    }

    public function receiver_rooms()
    {
        return $this->belongsToMany('User', 'room_id', 'receiver_id', 'sender_id');
    }

    public function resume()
    {
        return $this->hasOne('Resume', 'user_id');
    }

    public function experiences()
    {
        return $this->hasMany('UserExpericence', 'user_id');
    }

    public function prefered_jobs()
    {
        return $this->hasMany('PreferedJob', 'user_id');
    }

    public function skills()
    {
        return $this->hasMany('UserSkill', 'user_id');
    }

    public function user_workers_ignore()
    {
        return $this->belongsToMany('User', 'worker_ignores', 'worker_id', 'company_id');
    }

    public function company_workers_ignore()
    {
        return $this->belongsToMany('User', 'worker_ignores', 'company_id', 'worker_id');
    }

    public function worker_appointment_request()
    {
        return $this->belongsToMany('User', 'appointment_request', 'worker_id', 'company_id');
    }

    public function company_appointment_request()
    {
        return $this->belongsToMany('User', 'appointment_request', 'company_id', 'worker_id');
    }

    public function job_histories()
    {
        return $this->hasMany('JobHistory', 'user_id');
    }

    public function worker_interests()
    {
        return $this->belongsToMany('User', 'worker_interests', 'worker_id', 'company_id');
    }

    public function company_subscription()
    {
        return $this->belongsToMany('Subscription', 'company_subscriptions', 'company_id', 'subscription_id');
    }

    public function notifications()
    {
        return $this->hasMany('Notification', 'user_id');
    }

}