<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobHistoryTable extends Migration {

	public function up()
	{
		Schema::create('job_history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->enum('hired', array('true', 'false'))->nullable();
			$table->string('company_name', 191)->nullable();
			$table->text('story')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('job_history');
	}
}