<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 191)->nullable();
			$table->text('body')->nullable();
			$table->text('skills')->nullable();
			$table->date('end_date')->nullable();
			$table->integer('category_id')->unsigned();
			$table->integer('disability_id')->unsigned();
			$table->date('job_start_date')->nullable();
			$table->enum('job_system', array('undefined', 'trainer', 'contractor', 'temporary', 'full_time', 'remotely'))->nullable();
			$table->string('salary', 191)->nullable();
			$table->string('salary_currency', 191)->nullable();
			$table->string('transfer_salary', 191)->nullable();
			$table->string('transfer_salary_currency', 191)->nullable();
			$table->enum('health_allowance', array('A', 'B', 'C', 'VIP'))->nullable();
			$table->string('health_write', 191)->nullable();
			$table->integer('empty_jobs')->nullable();
			$table->enum('region', array('east', 'west', 'north', 'south', 'center'))->nullable();
			$table->integer('city_id')->unsigned();
			$table->integer('company_id')->unsigned();
			$table->enum('prefer_exp', array('junior', 'middle', 'experienced', 'undefined'))->nullable();
			$table->string('exp_years', 191)->nullable();
			$table->integer('settledown_country_id')->unsigned();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->integer('nationality_id')->unsigned();
			$table->integer('education_id')->unsigned();
			$table->enum('status', array('active', 'not_active'))->nullable();
			$table->enum('admin_opinion', array('accept', 'refuse', 'pending'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}