<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDocsTable extends Migration {

	public function up()
	{
		Schema::create('user_docs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->enum('type', array('image', 'video'))->nullable();
			$table->string('link_image', 191)->nullable();
			$table->enum('approved', array('true', 'false'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_docs');
	}
}