<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserExperiencesTable extends Migration {

	public function up()
	{
		Schema::create('user_experiences', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->date('start_job')->nullable();
			$table->date('end_job')->nullable();
			$table->string('company_name', 191)->nullable();
			$table->integer('company_field_id')->unsigned()->nullable();
			$table->string('job_title', 191)->nullable();
			$table->text('company_address')->nullable();
			$table->integer('city_id')->unsigned();
			$table->text('job_description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_experiences');
	}
}