<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subscription extends Model 
{

    protected $table = 'subscriptions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'ad_numbers', 'cv_count', 'price', 'website_interview');

    public function current_subscription()
    {
        return $this->hasMany('\User', 'current_subscription_id');
    }

    public function company_subscriptions()
    {
        return $this->belongsToMany('User', 'company_subscription', 'subscription_id', 'company_id');
    }

}