<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class UserExpericence extends Model 
{

    protected $table = 'user_experiences';
    public $timestamps = true;
    protected $fillable = array('user_id', 'start_job', 'end_job', 'company_name', 'company_field_id', 'job_title', 'company_address', 'city_id', 'job_description');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'company_field_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}