<?php

namespace Consolidated_Demands;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Consolidated_Demands extends Eloquent {

	protected $table = 'consolidated_demands';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function demands()
	{
		return $this->hasMany('Demands', 'id', 'fk_consolidated_demands_id');
	}

	public function bids()
	{
		return $this->hasMany('Bids', 'id', 'fk_consolidated_demands_id');
	}

}