<?php

namespace Demands;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Demands extends Eloquent {

	protected $table = 'demands';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->hasOne('Users_Details');
	}

	public function crops()
	{
		return $this->hasOne('Crops');
	}

	public function consolidated_demands()
	{
		return $this->belongsTo('Consolidated_Demands', 'id', 'fk_consolidated_demands_id');
	}

	public function marketing_agreement_logs()
	{
		return $this->hasMany('Marketing_Agreement_Logs', 'id', 'fk_demands_id');
	}

}