<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlantingPlanTable extends Migration {

	public function up()
	{
		Schema::create('planting_plan', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('fk_consolidated_demands_id');
			$table->integer('fk_bids_id');
			$table->float('farm_size', 10,2);
			$table->float('no_of_hills');
			$table->integer('fk_planting_plan_photos');
			$table->date('sowing_date');
			$table->date('transplanting_date');
			$table->string('status');
			$table->string('seed_provider', 255);
		});
	}

	public function down()
	{
		Schema::drop('planting_plan');
	}
}