<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEquipmentTable extends Migration {

	public function up()
	{
		Schema::create('equipment', function(Blueprint $table) {
			$table->increments('id_equipment');
			$table->string('baseMacAddress')->nullable();
			$table->string('baseSoftwareVersion')->nullable();
			$table->string('baseSerialNumber')->nullable();
			$table->string('lastKnownUpAt')->nullable();
			$table->string('sysUpTime')->nullable();
			$table->string('chassisAdminStatus')->nullable();
			$table->string('chassisOperationalStatus')->nullable();
			$table->string('name')->nullable();
			$table->string('model')->nullable();
			$table->integer('id_ov_foreign_key')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('equipment');
	}
}