<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTokensTable extends Migration {

	public function up()
	{
		Schema::create('tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->text('token')->nullable();
			$table->integer('user_id')->unsigned();
			$table->enum('device_type', array('ios', 'android'))->nullable();
			$table->enum('status', array('connected', 'disconnected'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tokens');
	}
}