<?php

namespace App;

class Menu extends Eloquent {

	protected $table = 'menus';
	public $timestamps = false;
	protected $fillable = array('name', 'description', 'price');

	public function categories()
	{
		return $this->belongsToMany('App\Category')->withPivot('id');
	}

	public function orders()
	{
		return $this->hasMany('App\Order');
	}

	public function customers()
	{
		return $this->belongsToMany('App\Customer')->withPivot('id')->withTimestamps();
	}

}