<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function parent()
    {
        return $this->belongsTo('App\Category', 'parent');
    }

    public function postRelation()
    {
        return $this->hasMany('App\PostRelationship', 'category');
    }

}