<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user');
			$table->integer('price');
			$table->text('title');
			$table->text('content');
			$table->text('excerpt');
			$table->string('description');
			$table->string('keywords');
			$table->integer('viewed');
			$table->string('post_type');
			$table->string('content_type');
			$table->string('featured_image');
			$table->string('slug');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}