<?php

namespace App\Models;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;
	protected $fillable = array('name', 'description', 'price_type', 'have_domain', 'renew_type', 'service_group_id', 'type');

	public function serviceGroup()
	{
		return $this->belongsTo('App\Models\ServiceGroup');
	}

	public function countryServices()
	{
		return $this->hasMany('App\Models\CountryService');
	}

	public function clientPayments()
	{
		return $this->hasMany('App\Models\ClientPayment');
	}

}