<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHmoFormRoomsTable extends Migration {

	public function up()
	{
		Schema::create('hmo_form_rooms', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('hmo_form_id')->unsigned();
			$table->integer('room_type')->unsigned()->nullable();
			$table->enum('room_usage', array('habitable', 'shared'));
			$table->integer('max_occupants');
			$table->integer('floor_number');
			$table->float('room_area')->nullable();
			$table->boolean('heating_facilities')->default(false);
			$table->boolean('boiler')->default(false);
			$table->boolean('fixed_appliance')->default(false);
			$table->boolean('portable')->default(false);
			$table->boolean('storage')->default(false);
			$table->boolean('log_burner')->default(false);
			$table->boolean('panel')->default(false);
			$table->boolean('radiator')->default(false);
			$table->boolean('washing_facilities');
			$table->boolean('hot_cold_water')->nullable();
			$table->boolean('hand_basin')->nullable();
			$table->boolean('shower');
			$table->boolean('splash_back')->nullable();
			$table->boolean('bath')->nullable();
			$table->integer('toilets')->nullable();
			$table->boolean('kitchen_facilities')->nullable();
			$table->boolean('cooker')->nullable();
			$table->boolean('fridge')->nullable();
			$table->boolean('drainer')->nullable();
			$table->boolean('worktop')->nullable();
			$table->boolean('hot_cold_water_kitchen')->nullable();
			$table->boolean('refuse')->nullable();
			$table->boolean('food_storage')->nullable();
			$table->boolean('kitchen_sink')->nullable();
			$table->boolean('freezer')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('hmo_form_rooms');
	}
}