<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('hmo_form_rooms', function(Blueprint $table) {
			$table->foreign('hmo_form_id')->references('id')->on('hmo_form')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_form_rooms', function(Blueprint $table) {
			$table->foreign('room_type')->references('id')->on('room_types')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('hmo_form_households', function(Blueprint $table) {
			$table->foreign('hmo_form_id')->references('id')->on('hmo_form')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_form_property_ownership', function(Blueprint $table) {
			$table->foreign('hmo_form_id')->references('id')->on('hmo_form')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_form_property_ownership', function(Blueprint $table) {
			$table->foreign('property_ownership_type_id')->references('id')->on('property_ownership_types')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('hmo_proposed_licence_holders', function(Blueprint $table) {
			$table->foreign('hmo_form_id')->references('id')->on('hmo_form')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_form_fit_and_proper', function(Blueprint $table) {
			$table->foreign('hmo_form_id')->references('id')->on('hmo_form')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_form_property_information', function(Blueprint $table) {
			$table->foreign('hmo_form_id')->references('id')->on('hmo_form')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_applicants', function(Blueprint $table) {
			$table->foreign('hmo_form_id')->references('id')->on('hmo_form')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_plh_organisations', function(Blueprint $table) {
			$table->foreign('hmo_form_id')->references('id')->on('hmo_form')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_form_safety_arrangements', function(Blueprint $table) {
			$table->foreign('hmo_form_id')->references('id')->on('hmo_form')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_form_households_rooms', function(Blueprint $table) {
			$table->foreign('household_id')->references('id')->on('hmo_form_households')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_form_households_rooms', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('hmo_form_rooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('hmo_form_rooms', function(Blueprint $table) {
			$table->dropForeign('hmo_form_rooms_hmo_form_id_foreign');
		});
		Schema::table('hmo_form_rooms', function(Blueprint $table) {
			$table->dropForeign('hmo_form_rooms_room_type_foreign');
		});
		Schema::table('hmo_form_households', function(Blueprint $table) {
			$table->dropForeign('hmo_form_households_hmo_form_id_foreign');
		});
		Schema::table('hmo_form_property_ownership', function(Blueprint $table) {
			$table->dropForeign('hmo_form_property_ownership_hmo_form_id_foreign');
		});
		Schema::table('hmo_form_property_ownership', function(Blueprint $table) {
			$table->dropForeign('hmo_form_property_ownership_property_ownership_type_id_foreign');
		});
		Schema::table('hmo_proposed_licence_holders', function(Blueprint $table) {
			$table->dropForeign('hmo_proposed_licence_holders_hmo_form_id_foreign');
		});
		Schema::table('hmo_form_fit_and_proper', function(Blueprint $table) {
			$table->dropForeign('hmo_form_fit_and_proper_hmo_form_id_foreign');
		});
		Schema::table('hmo_form_property_information', function(Blueprint $table) {
			$table->dropForeign('hmo_form_property_information_hmo_form_id_foreign');
		});
		Schema::table('hmo_applicants', function(Blueprint $table) {
			$table->dropForeign('hmo_applicants_hmo_form_id_foreign');
		});
		Schema::table('hmo_plh_organisations', function(Blueprint $table) {
			$table->dropForeign('hmo_plh_organisations_hmo_form_id_foreign');
		});
		Schema::table('hmo_form_safety_arrangements', function(Blueprint $table) {
			$table->dropForeign('hmo_form_safety_arrangements_hmo_form_id_foreign');
		});
		Schema::table('hmo_form_households_rooms', function(Blueprint $table) {
			$table->dropForeign('hmo_form_households_rooms_household_id_foreign');
		});
		Schema::table('hmo_form_households_rooms', function(Blueprint $table) {
			$table->dropForeign('hmo_form_households_rooms_room_id_foreign');
		});
	}
}